package com.mth.requestsecret.controller;

import com.alibaba.fastjson.JSONObject;
import com.mth.requestsecret.service.RestTemplateService;
import com.mth.requestsecret.util.AESUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 招必得接口
 *
 * @author MaTianHao
 * @date 2020/8/20
 */
@RestController
@Slf4j
public class ZbdController {

    @Autowired
    private RestTemplateService restTemplateService;

    /**
     * 2.2 获取标段信息接口
     *
     * @param beginDate
     * @param endDate
     * @return
     * @throws Exception
     */
    @PostMapping("/getTenderInfo")
    public ResponseEntity getTenderInfo(String beginDate, String endDate) throws Exception {
        String apiMethod = "/la/supervise/getTenderInfo.do";
        // 1. 设置参数
        JSONObject requestParam = new JSONObject();
        requestParam.put("BeginDate", beginDate);
        requestParam.put("EndDate", endDate);

        // 2. 加密参数并发送请求
        return encryptRequestParam(requestParam, apiMethod);
    }


    /**
     * 2.3 获取报名信息接口
     *
     * @param tenderNo
     * @return
     * @throws Exception
     */
    @PostMapping("/getTenderBidInfo")
    public ResponseEntity getTenderBidInfo(String tenderNo) throws Exception {
        String apiMethod = "/la/supervise/getTenderBidInfo.do";
        // 1. 设置参数
        JSONObject requestParam = new JSONObject();
        requestParam.put("TenderNo", tenderNo);

        // 2. 加密参数并发送请求
        return encryptRequestParam(requestParam, apiMethod);
    }


    /**
     * 2.4 获取开标信息接口
     *
     * @param tenderNo
     * @return
     * @throws Exception
     */
    @PostMapping("/getTenderOpenBidInfo")
    public ResponseEntity getTenderOpenBidInfo(String tenderNo) throws Exception {
        String apiMethod = "/la/supervise/getTenderOpenBidInfo.do";
        // 1. 设置参数
        JSONObject requestParam = new JSONObject();
        requestParam.put("TenderNo", tenderNo);

        // 2. 加密参数并发送请求
        return encryptRequestParam(requestParam, apiMethod);
    }


    /**
     * 2.5 获取中标信息接口
     *
     * @param tenderNo
     * @return
     * @throws Exception
     */
    @PostMapping("/getTenderWinInfo")
    public ResponseEntity getTenderWinInfo(String tenderNo) throws Exception {
        String apiMethod = "/la/supervise/getTenderWinInfo.do";
        // 1. 设置参数
        JSONObject requestParam = new JSONObject();
        requestParam.put("TenderNo", tenderNo);

        // 2. 加密参数并发送请求
        return encryptRequestParam(requestParam, apiMethod);
    }


    /**
     * 2.6 获取评标信息接口
     *
     * @param tenderNo
     * @return
     * @throws Exception
     */
    @PostMapping("/getTenderEvalInfo")
    public ResponseEntity getTenderEvalInfo(String tenderNo) throws Exception {
        String apiMethod = "/la/supervise/getTenderEvalInfo.do";
        // 1. 设置参数
        JSONObject requestParam = new JSONObject();
        requestParam.put("TenderNo", tenderNo);

        // 2. 加密参数并发送请求
        return encryptRequestParam(requestParam, apiMethod);
    }


    /**
     * 异常响应体
     */
    private ResponseEntity exceptionResponseEntity() {
        JSONObject resultBody = new JSONObject();
        resultBody.put("success", false);
        resultBody.put("error", "时间戳接口返回异常");
        return ResponseEntity
                .status(HttpStatus.INTERNAL_SERVER_ERROR)
                .header(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE)
                .body(resultBody);
    }

    /**
     * 根据 key 和 iv 加密参数
     */
    private ResponseEntity encryptRequestParam(JSONObject requestParam, String apiMethod) throws Exception {
        String encrypt = AESUtils.encrypt(requestParam.toJSONString());
        JSONObject param = new JSONObject();
        param.put("_args", encrypt);
        log.info("{} - 参数：{}", apiMethod, requestParam.toJSONString());

        try {
            return restTemplateService.zbdSendRequest(param, apiMethod);
        } catch (Exception e) {
            return exceptionResponseEntity();
        }
    }
}
