package com.mth.requestsecret.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.Security;
import java.util.Base64;

/**
 * @author MaTianHao
 * @date 2020/8/19
 */
@Slf4j
public class AESUtils {

    // 招必得加密参数
    /**
     * AES/CBC协定密钥key（256位）
     */
    private final static String ZBD_KEY = "LaKEXJRbiocF1iYOssFgj5Tdq1m0kFVO";
    /**
     * AES/CBC协定向量iv（128位）
     */
    private final static String ZBD_IV = "LaKEXJRbiocF1iYO";


    // 审管办加密参数
    /**
     * key
     */
    private final static String SGB_KEY = "SAD68C6X";
    /**
     * 偏移向量iv
     */
    private final static byte[] SGB_IV = {(byte) 0x12, (byte) 0x34, (byte) 0x56, (byte) 0x78, (byte) 0x90, (byte) 0xAB, (byte) 0xCD, (byte) 0xEF};

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    /**
     * 招必得：aes加密
     */
    public static String encrypt(String sstr) throws Exception {
        byte[] keyByte = ZBD_KEY.getBytes("utf-8");
        SecretKeySpec keySpec = new SecretKeySpec(keyByte, "AES");

        // 算法/模式/补码方式
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] ivByte = ZBD_IV.getBytes(StandardCharsets.UTF_8);

        // 使用CBC模式，需要一个向量iv，可增加加密算法的强度
        IvParameterSpec iv = new IvParameterSpec(ivByte);
        cipher.init(Cipher.ENCRYPT_MODE, keySpec, iv);
        byte[] encrype = cipher.doFinal(sstr.getBytes());

        // 此处使用BASE64做转码功能，同时能起到2次加密的作用。
        return Base64.getEncoder().encodeToString(encrype);
    }

    /**
     * 招必得：aes解密
     */
    public static String decrypt(String sstr) {
        try {
            byte[] keyByte = ZBD_KEY.getBytes("utf-8");
            SecretKeySpec keySpec = new SecretKeySpec(keyByte, "AES");
            // 算法/模式/补码方式
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

            // 使用CBC模式，需要一个向量iv，可增加加密算法的强度
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ZBD_IV.getBytes());
            cipher.init(Cipher.DECRYPT_MODE, keySpec, ivParameterSpec);
            byte[] encrype = Base64.getDecoder().decode(sstr);
            byte[] origin = cipher.doFinal(encrype);

            return new String(origin);
        } catch (Exception e) {
            return null;
        }
    }


    /**
     * 审管办接口：des加密
     */
    public static String desEncrypt(String sstr) throws Exception {
        // 算法/模式/补码方式
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS7Padding");
        // key
        SecretKeySpec keySpec = new SecretKeySpec(SGB_KEY.getBytes("utf-8"), "AES");
        // iv
        IvParameterSpec iv = new IvParameterSpec(SGB_IV);

        cipher.init(Cipher.ENCRYPT_MODE, keySpec, iv);
        if (StringUtils.isEmpty(sstr)) {
            return null;
        }
        byte[] encrype = cipher.doFinal(sstr.getBytes());

        // 此处使用BASE64做转码功能，同时能起到2次加密的作用。
        return Base64.getEncoder().encodeToString(encrype);
    }

    /**
     * 审管办接口：des解密
     */
    public static String desDecrypt(String sstr) {
        try {
            // 算法/模式/补码方式
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS7Padding");
            // key
            SecretKeySpec keySpec = new SecretKeySpec(SGB_KEY.getBytes("utf-8"), "AES");
            // iv
            IvParameterSpec iv = new IvParameterSpec(SGB_IV);

            cipher.init(Cipher.DECRYPT_MODE, keySpec, iv);
            byte[] encrype = Base64.getDecoder().decode(sstr);
            byte[] origin = cipher.doFinal(encrype);

            return new String(origin);
        } catch (Exception e) {
            return null;
        }
    }

}
