package com.mth.requestsecret.util;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @ClassName: DSLUtils
 * @Description:
 * @author:  yuhl
 * @date: Jul 10, 2017 6:00:45 PM
 */
public class DSLUtils {

    public static String dateToString(Date data, String formatType) {  
        return new SimpleDateFormat(formatType).format(data);  
    }  

    public static String longToString(long currentTime, String formatType)  
            throws Exception {  
        Date date = longToDate(currentTime, formatType);
        String strTime = dateToString(date, formatType);
        return strTime;  
    }  

    public static Date stringToDate(String strTime, String formatType)  
            throws Exception {  
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);  
        Date date = null;  
        date = formatter.parse(strTime);  
        return date;  
    }  

    public static Date longToDate(long currentTime, String formatType)  
            throws Exception {  
        Date dateOld = new Date(currentTime);
        String sDateTime = dateToString(dateOld, formatType);
        Date date = stringToDate(sDateTime, formatType);
        return date;  
    }  
   
    public static long stringToLong(String strTime, String formatType)
            throws Exception {  
        Date date = stringToDate(strTime, formatType);
        if (date == null) {  
            return 0;  
        } else {  
            long currentTime = dateToLong(date);
            return currentTime;  
        }  
    }  
   
    public static long dateToLong(Date date) {
        return date.getTime();
    }  
}
