package com.mth.requestsecret.util;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpHead;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.regex.Pattern;

import static java.lang.System.out;

public class QccTestMain {

    // 查看我的秘钥 我的Key
    private static final String appkey = "57bdcf2784834ff6a96ec3168184c012";
    private static final String seckey = "96C7DF69FCF5D4C170844D81C8074003";

    // 获取返回码 Res Code
    static class HttpCodeRegex {
        private static final String ABNORMAL_REGIX = "(101)|(102)";
        private static final Pattern pattern = Pattern.compile(ABNORMAL_REGIX);
        protected static boolean isAbnornalRequest(final String status) {
            return pattern.matcher(status).matches();
        }
    }

    // 获取Auth Code
    protected static final String[] RandomAuthentHeader() {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000);
        String[] authentHeaders = new String[] { DigestUtils.md5Hex(appkey.concat(timeSpan).concat(seckey)).toUpperCase(), timeSpan };
        return authentHeaders;
    }

    // 解析JSON
    protected static String FormartJson(String jsonString, String key) throws JSONException {
        JSONObject jObject = new JSONObject(jsonString);
        return (String) jObject.get(key);
    }

    // pretty print 返回值
    protected static void PrettyPrintJson(String jsonString) throws JSONException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object obj = mapper.readValue(jsonString, Object.class);
            String indented = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            out.println(indented);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String reqInterNme = "http://api.qichacha.com/ECIV4/Search";
        String paramStr = "keyword=浙江华通云数据科技有限公司";
        String status = "";
        try {
            // auth header setting
            HttpHead reqHeader = new HttpHead();
            String[] autherHeader = RandomAuthentHeader();
            reqHeader.setHeader("Token", autherHeader[0]);
            reqHeader.setHeader("Timespan", autherHeader[1]);
            final String reqUri = reqInterNme.concat("?key=").concat(appkey).concat("&").concat(paramStr);
            String tokenJson = QccHttpUtil.httpGet(reqUri, reqHeader.getAllHeaders());
            out.println(String.format("==========================>this is response:{%s}", tokenJson));

            // parse status from json
            status = FormartJson(tokenJson, "Status");
            out.println(String.format("==========================>Status:{%s}", status));
            if (!com.mth.requestsecret.util.QccTestMain.HttpCodeRegex.isAbnornalRequest(status)) {
                PrettyPrintJson(tokenJson);
            }
        } catch (Exception e1) {
            e1.printStackTrace();
        }
    }

}
