package com.mth.requestsecret.controller;

import com.google.common.collect.Maps;
import com.mth.requestsecret.vo.shuilijuvo.JhxdVO;
import com.mth.requestsecret.vo.shuilijuvo.XmcbkVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

/**
 * 水利局接口
 *
 * @author MaTianHao
 * @date 2020/9/4
 */
@RestController
@Slf4j
public class SLJController {

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 请求验证接口
     */
    public List<String> requestValidationAndGetCookie() {
        final String url = "http://122.224.98.154:82/api/User/GetOtherUser?Ticket=5rWL6K+VJjEyMzQ1Ng==&format=json";
        ResponseEntity<String> entity = restTemplate.getForEntity(url, String.class);
        return entity.getHeaders().get("Set-Cookie");
    }

    /**
     * 通过请求验证接口设置cookie
     */
    private HttpHeaders setCookie() {
        List<String> cookie = requestValidationAndGetCookie();
        HttpHeaders headers = new HttpHeaders();
        headers.put("Cookie", cookie);
        return headers;
    }

    /**
     * 接口一：项目储备库
     */
    @PostMapping("/xmcbk")
    public ResponseEntity xmcbk(XmcbkVO param) {

        String url = "http://122.224.98.154:82/api/Project/GetProjectCbk" +
                "?format=json" +
                "&townName={townName}" +
                "&projectName={projectName}" +
                "&projectTypeName={projectTypeName}" +
                "&isOrder={isOrder}" +
                "&year={year}" +
                "&pageIndex={pageIndex}" +
                "&pageSize={pageSize}";

        // 设置参数
        Map<String, Object> map = Maps.newHashMap();
        map.put("format", "json");
        map.put("townName", param.getTownName());
        map.put("projectName", param.getProjectName());
        map.put("projectTypeName", param.getProjectTypeName());
        map.put("year", param.getYear());
        map.put("pageIndex", param.getPageIndex());
        map.put("pageSize", param.getPageSize());
        map.put("isOrder", param.getIsOrder());

        // 设置cookie
        HttpHeaders headers = setCookie();

        HttpEntity entity = new HttpEntity<>(headers);
        return restTemplate.exchange(url, HttpMethod.GET, entity, String.class, map);
    }

    /**
     * 接口二：计划下达
     */
    @PostMapping("/jhxd")
    public ResponseEntity jhxd(JhxdVO param) {

        String url = "http://122.224.98.154:82/api/PlanTask/GetPlanTaskList" +
                "?format=json" +
                "&townName={townName}" +
                "&projectName={projectName}" +
                "&projectTypeName={projectTypeName}" +
                "&unit={unit}" +
                "&year={year}" +
                "&pageIndex={pageIndex}" +
                "&pageSize={pageSize}";

        // 设置参数
        Map<String, Object> map = Maps.newHashMap();
        map.put("format", "json");
        map.put("townName", param.getTownName());
        map.put("projectName", param.getProjectName());
        map.put("projectTypeName", param.getProjectTypeName());
        map.put("year", param.getYear());
        map.put("pageIndex", param.getPageIndex());
        map.put("pageSize", param.getPageSize());
        map.put("unit", param.getUnit());

        // 设置cookie
        HttpHeaders headers = setCookie();

        HttpEntity entity = new HttpEntity<>(headers);
        return restTemplate.exchange(url, HttpMethod.GET, entity, String.class, map);
    }
}
