package com.mth.requestsecret.controller;

import com.mth.requestsecret.vo.shuguanjuvo.CxdwzcVO;
import com.mth.requestsecret.vo.shuguanjuvo.HtbacxVO;
import com.mth.requestsecret.vo.shuguanjuvo.JzmxsjVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;

/**
 * 资产云接口
 *
 * @author MaTianHao
 * @date 2020/8/7
 */
public class AssetCloudController {

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 三十五查询单位资产列表
     * @param cxdwzcVO
     * @return
     */
    @PostMapping("/cxdwzc")
    public ResponseEntity<String> cxdwzc(@RequestBody CxdwzcVO cxdwzcVO) {
        String url = "http://59.202.50.194:8090/fcfa_restapi/api/asset/getOrgAssetList";
        // api参数
        HashMap<String, Object> map = new HashMap<>();
        long timeStamp = System.currentTimeMillis();
        map.put("assetCode",cxdwzcVO.getAssetCode());
        map.put("assetTypeCode",cxdwzcVO.getAssetTypeCode());
        map.put("gbTypeCode",cxdwzcVO.getGbTypeCode());
        map.put("rgCode",cxdwzcVO.getRgCode());
        map.put("status",cxdwzcVO.getStatus());
        map.put("timeStamp",timeStamp);
        map.put("pageNumber",cxdwzcVO.getPageNumber());
        map.put("pageSize",cxdwzcVO.getPageSize());
        map.put("orgCode",cxdwzcVO.getOrgCode());
        map.put("sysCode",cxdwzcVO.getSysCode());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authority","d2ViLDM2MDAsNitVTWhRYmtZV21kV090OUlPZ0tkcz");
        // 发送请求
        HttpEntity<HashMap<String, Object>> request = new HttpEntity<>(map, headers);
        return restTemplate.exchange(url, HttpMethod.POST, request, String.class);
    }

    /**
     * 三十六 获取记账明细数据接口(通用接口)
     * @param jzmxsjVO
     * @return
     */
    @PostMapping("/jzmxsj")
    public ResponseEntity<String> jzmxsj(@RequestBody JzmxsjVO jzmxsjVO) {
        String url = "http://59.202.50.194:8090/fcfa_restapi/api/asset/getAccountingData";
        // api参数
        HashMap<String, Object> map = new HashMap<>();
        long timeStamp = System.currentTimeMillis();
        map.put("accperiodmth",jzmxsjVO.getAccperiodmth());
        map.put("businessType",jzmxsjVO.getBusinessType());
        map.put("rgCode",jzmxsjVO.getRgCode());
        map.put("periodyear",jzmxsjVO.getPeriodyear());
        map.put("pageNumber",jzmxsjVO.getPageNumber());
        map.put("pageSize",jzmxsjVO.getPageSize());
        map.put("orgCode",jzmxsjVO.getOrgCode());
        map.put("sysCode",jzmxsjVO.getSysCode());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authority","d2ViLDM2MDAsNitVTWhRYmtZV21kV090OUlPZ0tkcz");
        // 发送请求
        HttpEntity<HashMap<String, Object>> request = new HttpEntity<>(map, headers);
        return restTemplate.exchange(url, HttpMethod.POST, request, String.class);
    }

    /**
     * 三十七 根据资产ID 获取资产详情
     * @param
     * @return
     */
    @GetMapping("/hqzcxq")
    public ResponseEntity<String> hqzcxq(String sysCode,String rgCode,String orgCode,String assetId) {
        String u = "http://59.202.50.194:8090/fcfa_restapi/api/asset/assetInfo/";
        // api参数
        String url = u+ sysCode+"@"+ rgCode+"@"+orgCode+"@"+assetId;
        HashMap<String, Object> map = new HashMap<>();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authority","d2ViLDM2MDAsNitVTWhRYmtZV21kV090OUlPZ0tkcz");
        // 发送请求
        HttpEntity<HashMap<String, Object>> request = new HttpEntity<>(map, headers);
        return restTemplate.exchange(url, HttpMethod.GET, request, String.class);
    }

    /**
     * 三十八 合同备案查询
     * @param htbacxVO
     * @return
     */
    @PostMapping("/htbacx")
    public ResponseEntity<String> htbacx(@RequestBody HtbacxVO htbacxVO) {
        String url = "http://59.202.50.194:8090/fcfa_restapi/api/contract/getContractList";
        // api参数
        HashMap<String, Object> map = new HashMap<>();
        map.put("rgCode",htbacxVO.getRgCode());
        map.put("pageNumber",htbacxVO.getPageNumber());
        map.put("pageSize",htbacxVO.getPageSize());
        map.put("orgCode",htbacxVO.getOrgCode());
        map.put("sysCode",htbacxVO.getSysCode());
        map.put("contractTypeCode",htbacxVO.getContractTypeCode());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authority","d2ViLDM2MDAsNitVTWhRYmtZV21kV090OUlPZ0tkcz");
        // 发送请求
        HttpEntity<HashMap<String, Object>> request = new HttpEntity<>(map, headers);
        return restTemplate.exchange(url, HttpMethod.POST, request, String.class);
    }
}
