package com.mth.requestsecret.controller;


import com.alibaba.fastjson.JSONObject;
import com.mth.requestsecret.util.QccHttpUtil;
import com.mth.requestsecret.util.QccUtil;
import org.apache.http.client.methods.HttpHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


/**
 * 企查查接口
 *
 * @author zx
 * @date 2020/8/18
 */
@RestController
public class QccController {

    // 查看我的秘钥 我的Key
    private static final String appkey = "118c9e6bb7054d0fad0be04fd67215db";
    private static final String seckey = "FB35A314C04E8194F5E8977DA2ED1344";

    private Logger log = LoggerFactory.getLogger(QccController.class);

    /**
     * 工商企业信息模糊查询
     * @param keyword
     * @return
     */
    @GetMapping("/qiyeSearch")
    public ResponseEntity<JSONObject> qiyeSearch(@RequestParam String keyword,@RequestParam String pageSize,@RequestParam String pageIndex) throws Exception {
        String interfaceUrl = "http://api.qichacha.com/ECIV4/Search";
        HttpHead reqHeader = new HttpHead();
        String[] autherHeader = QccUtil.RandomAuthentHeader(appkey,seckey);
        reqHeader.setHeader("Token", autherHeader[0]);
        reqHeader.setHeader("Timespan", autherHeader[1]);
        String reqUri = interfaceUrl.concat("?key=").concat(appkey).concat("&keyword=").concat(keyword)
                .concat("&pageSize=").concat(pageSize).concat("&pageIndex=").concat(pageIndex);
        String resultJson = QccHttpUtil.httpGet(reqUri, reqHeader.getAllHeaders());
        JSONObject jObject = JSONObject.parseObject(resultJson);
        log.info("企查查企业查询接口返回结果为："+resultJson);
        return new ResponseEntity<JSONObject>(jObject, HttpStatus.OK);
    }


    /**
     * 企业股东信息查询
     * @param keyword
     * @return
     */
    @GetMapping("/qiyePartnerInfoQuery")
    public ResponseEntity<JSONObject> qiyePartnerInfoQuery(@RequestParam String keyword,@RequestParam String pageSize,@RequestParam String pageIndex) throws Exception {
        String interfaceUrl = "http://api.qichacha.com/ECIPartner/GetList";
        HttpHead reqHeader = new HttpHead();
        String[] autherHeader = QccUtil.RandomAuthentHeader(appkey,seckey);
        reqHeader.setHeader("Token", autherHeader[0]);
        reqHeader.setHeader("Timespan", autherHeader[1]);
        String reqUri = interfaceUrl.concat("?key=").concat(appkey).concat("&searchKey=").concat(keyword)
                .concat("&pageSize=").concat(pageSize).concat("&pageIndex=").concat(pageIndex);
        String resultJson = QccHttpUtil.httpGet(reqUri, reqHeader.getAllHeaders());
        JSONObject jObject = JSONObject.parseObject(resultJson);
        log.info("企查查企业股东信息查询接口返回结果为："+resultJson);
        ResponseEntity<JSONObject> result = new ResponseEntity<JSONObject>(jObject, HttpStatus.OK);
        return result;
    }


    /**
     * 个人历史担任法人企业查询
     * @param searchKey 公司名、注册号、社会统一信用 代码，KeyNo
     * @param personName 人员姓名
     * @return
     */
    @GetMapping("/personHisOperCompany")
    public ResponseEntity<JSONObject> personHisOperCompany(@RequestParam String searchKey,@RequestParam String personName,@RequestParam String pageSize,@RequestParam String pageIndex) throws Exception {
        String interfaceUrl = "http://api.qichacha.com/PersonHisOperCompany/GetList";
        HttpHead reqHeader = new HttpHead();
        String[] autherHeader = QccUtil.RandomAuthentHeader(appkey,seckey);
        reqHeader.setHeader("Token", autherHeader[0]);
        reqHeader.setHeader("Timespan", autherHeader[1]);
        String reqUri = interfaceUrl.concat("?key=").concat(appkey).concat("&searchKey=").concat(searchKey).concat("&personName=").concat(personName)
                .concat("&pageSize=").concat(pageSize).concat("&pageIndex=").concat(pageIndex);
        String resultJson = QccHttpUtil.httpGet(reqUri, reqHeader.getAllHeaders());
        JSONObject jObject = JSONObject.parseObject(resultJson);

        log.info("个人历史担任法人企业查询接口返回结果为："+resultJson);
        return new ResponseEntity<JSONObject>(jObject, HttpStatus.OK);
    }


}
