package com.mth.requestsecret.controller;

import com.mth.requestsecret.vo.shuguanjuvo.*;
import com.mth.requestsecret.service.RestTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 纪委智慧监督平台接口
 *
 * @author MaTianHao
 * @date 2020/7/13
 */
@RestController
public class RequestController {

    @Autowired
    private RestTemplateService restTemplateService;


    /**
     * 五.浙江省电力业务开放数据查询
     *
     * @param strJson     业务数据
     * @param dsgeSign    签名数据
     * @param channelCode 渠道编码
     * @return
     */
    @PostMapping("zjsdlywkfsjcx")
    public ResponseEntity<String> zjsdlywkfsjcx(String strJson, String dsgeSign,
                                                String channelCode, String additional) {
        String apiMethod = "zjsdlywkfsjcx.action";
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("strJson", strJson);
        paramMap.add("dsgeSign", dsgeSign);
        paramMap.add("channelCode", channelCode);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六.浙江省教育部高校学籍姓名及证件号码查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsjybgxxjxmjzjhmcx")
    public ResponseEntity<String> zjsjybgxxjxmjzjhmcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsjybgxxjxmjzjhmcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("xm", param.getUserName());
        paramMap.add("zjhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七.浙江省出入境证件查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjscrjzjcx")
    public ResponseEntity<String> zjscrjzjcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjscrjzjcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 八.浙江省公安厅居民身份证（新）查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsgatjmsfzxcx")
    public ResponseEntity<String> zjsgatjmsfzxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsgatjmsfzxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("czrkxm", param.getUserName());
        paramMap.add("czrkgmsfhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 九.浙江省公安厅居民身份证查询（电子证照)
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsgatjmsfzcxdzzz")
    public ResponseEntity<String> zjsgatjmsfzcxdzzz(NinthParamVO param) {
        // api签名
        String apiMethod = "zjsgatjmsfzcxdzzz.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("User_Name", param.getUserName());
        paramMap.add("User_ID", param.getIdCard());
        paramMap.add("sfhm", param.getSfhm());
        paramMap.add("Organization", param.getOrganization());
        paramMap.add("Organization_Id", param.getOrganizationId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十.	浙江省公安户籍业务办理
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsgahjywbl")
    public ResponseEntity<String> zjsgahjywbl(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsgahjywbl.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();

        paramMap.add("xm", param.getUserName());
        paramMap.add("gmsfhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }


    /**
     * 十一.浙江省中华人民共和国护照查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjszhrmghghzcx")
    public ResponseEntity<String> zjszhrmghghzcx(NinthParamVO param) {
        // api签名
        String apiMethod = "zjszhrmghghzcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("User_Name", param.getUserName());
        paramMap.add("User_ID", param.getIdCard());
        paramMap.add("zjhm", param.getSfhm());
        paramMap.add("Organization", param.getOrganization());
        paramMap.add("Organization_Id", param.getOrganizationId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十二.浙江省失信执行人信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjssxzxrxxcx")
    public ResponseEntity<String> zjssxzxrxxcx(TwelfthParamVO param) {
        // api签名
        String apiMethod = "zjssxzxrxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("executorNature", param.getExecutorNature());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十三.	浙江省民政部_社会团体法人登记证书查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsmzbshttfrdjzscx")
    public ResponseEntity<String> zjsmzbshttfrdjzscx(CompanyParamVO param) {
        // api签名
        String apiMethod = "zjsmzbshttfrdjzscx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("org_name", param.getOrgName());
        paramMap.add("usc_code", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十四.	浙江省发展改革委_社团法人信息查询
     *
     * @param
     * @return
     */
    @PostMapping("/stfrxxcx")
    public ResponseEntity<String> stfrxxcx(FourteenthParamVO param) {
        // api签名
        String apiMethod = "stfrxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("code", param.getCode());
        paramMap.add("code_type", param.getCodeType());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十五.	浙江省执行案件信息查询
     *
     * @param
     * @return
     */
    @PostMapping("/zjszxajxxcx")
    public ResponseEntity<String> zjszxajxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjszxajxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("DSRMC", param.getUserName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十六.	浙江省人社厅高级职称证书查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsrstgjzczscx")
    public ResponseEntity<String> zjsrstgjzczscx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsrstgjzczscx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("xm", param.getUserName());
        paramMap.add("zjhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十七.	浙江省公安厅中华人民共和国机动车登记证书查询
     *
     * @return
     */
    @PostMapping("/zjsgatzhrmghgjdcdjzscx")
    public ResponseEntity<String> zjsgatzhrmghgjdcdjzscx(SeventeenthVO param) {
        // api签名
        String apiMethod = "zjsgatzhrmghgjdcdjzscx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("powerMatters", param.getPowerMatters());
        paramMap.add("subPowerMatters", param.getSubPowerMatters());
        paramMap.add("User_ID", param.getIdCard());
        paramMap.add("User_Name", param.getUserName());
        paramMap.add("hphm", param.getCarNo());
        paramMap.add("hpzl", param.getCarNoType());
        paramMap.add("projectId", param.getProjectId());
        paramMap.add("Organization", param.getOrganization());
        paramMap.add("Organization_ID", param.getOrganizationId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十八.	浙江省人社厅初中级职称证书查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsrstczjzczscx")
    public ResponseEntity<String> zjsrstczjzczscx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsrstczjzczscx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("xm", param.getUserName());
        paramMap.add("zjhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 十九.	浙江省民政厅社会团体法人证信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsmztshttfrzxxcx")
    public ResponseEntity<String> zjsmztshttfrzxxcx(CompanyParamVO param) {
        // api签名
        String apiMethod = "zjsmztshttfrzxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("tyxydm", param.getUniscId());
        paramMap.add("stmc", param.getOrgName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十.	浙江省国土资源厅不动产权证（新）查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsgtzytbdcqzxcx")
    public ResponseEntity<String> zjsgtzytbdcqzxcx(TwentiethVO param) {
        // api签名
        String apiMethod = "zjsgtzytbdcqzxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("bdcqzh", param.getBdcqzh());
        paramMap.add("xzqbm", param.getXzqbm());
        paramMap.add("zjh", param.getIdCard());
        paramMap.add("qlr", param.getUserName());
        paramMap.add("zl", param.getZl());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十一.浙江省房地产权信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsfdcqxxcx")
    public ResponseEntity<String> zjsfdcqxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsfdcqxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("qlrmc", param.getUserName());
        paramMap.add("zjh", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十二.浙江省行驶证信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/vehicleQmInfo")
    public ResponseEntity<String> vehicleQmInfo(TwentySecondParamVO param) {
        // api签名
        String apiMethod = "vehicleQmInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("HPHM", param.getCarNo());
        paramMap.add("sfzmhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十三.	浙江省社会团体法人登记证书查询
     *
     * @param uniscId 统一社会信用代码
     * @return
     */
    @PostMapping("/zjsshttfrdjzscx")
    public ResponseEntity<String> zjsshttfrdjzscx(String uniscId) {
        // api签名
        String apiMethod = "zjsshttfrdjzscx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("uniscId", uniscId);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十四.浙江杭州公积金贷款信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjhzgjjdkxxcx")
    public ResponseEntity<String> zjhzgjjdkxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjhzgjjdkxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("name", param.getUserName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十五.浙江省户口本查询（电子证照）
     *
     * @param param
     * @return
     */
    @PostMapping("/zjshkbcxdzzz")
    public ResponseEntity<String> zjshkbcxdzzz(BaseParamVO param) {
        // api签名
        String apiMethod = "zjshkbcxdzzz.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("czrkgmsfhm", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十六.浙江杭州民政局婚姻信息查询（姓名身份证）
     *
     * @param param
     * @return
     */
    @PostMapping("/zjshzmzjhyxxcxxmsfz")
    public ResponseEntity<String> zjshzmzjhyxxcxxmsfz(BaseParamVO param) {
        // api签名
        String apiMethod = "zjshzmzjhyxxcxxmsfz.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("sfz", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十七.浙江省流动人口基本信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/floatingPopulationInfo")
    public ResponseEntity<String> floatingPopulationInfo(BaseParamVO param) {
        // api签名
        String apiMethod = "floatingPopulationInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十八.浙江省大学生毕业信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsdxsbyxxcx")
    public ResponseEntity<String> zjsdxsbyxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsdxsbyxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 二十九.浙江杭州民政转业士官信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/hqzjhzmzscjrxx")
    public ResponseEntity<String> hqzjhzmzscjrxx(BaseParamVO param) {
        // api签名
        String apiMethod = "hqzjhzmzscjrxx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("name", param.getUserName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十.浙江省城乡居民财政补助信息（乡镇公共财政服务平台已有信息）信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjscxjmczbtxx")
    public ResponseEntity<String> zjscxjmczbtxx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjscxjmczbtxx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十一.浙江省资产评估机构信息表查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjszcpgjgxxbcx")
    public ResponseEntity<String> zjszcpgjgxxbcx(CompanyParamVO param) {
        // api签名
        String apiMethod = "zjszcpgjgxxbcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("pgjgdm", param.getOrgName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十二.浙江省困难群众价格补贴信息查询
     *
     * @param id
     * @param additional
     * @return
     */
    @PostMapping("/zjsknqzjhbtxxcx")
    public ResponseEntity<String> zjsknqzjhbtxxcx(String id, String additional) {
        // api签名
        String apiMethod = "zjsknqzjhbtxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id", id);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十三.浙江省农村五保对象供养情况查询
     *
     * @param areaCode
     * @param additional
     * @return
     */
    @PostMapping("/zjsncwbdxgyqkcx")
    public ResponseEntity<String> zjsncwbdxgyqkcx(String areaCode, String additional) {
        // api签名
        String apiMethod = "zjsncwbdxgyqkcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("ncwbdx_xzqh", areaCode);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十四.浙江省农业会展企业黑名单信息查询
     *
     * @param companyName
     * @param additional
     * @return
     */
    @PostMapping("/zjsnyhzqyhmdxxcx")
    public ResponseEntity<String> zjsnyhzqyhmdxxcx(String companyName, String additional) {
        // api签名
        String apiMethod = "zjsnyhzqyhmdxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("companyName", companyName);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十五.浙江省年报信息（工商）查询
     *
     * @param regNo      注册号
     * @param additional
     * @return
     */
    @PostMapping("/zjsnbxxgscx")
    public ResponseEntity<String> zjsnbxxgscx(String regNo, String additional) {
        // api签名
        String apiMethod = "zjsnbxxgscx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("regNo", regNo);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十六.浙江省交通建设工程监理单位资质信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsjtjsgcjldwzzxxcx")
    public ResponseEntity<String> zjsjtjsgcjldwzzxxcx(CompanyParamVO param) {
        // api签名
        String apiMethod = "zjsjtjsgcjldwzzxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("uniscId", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十七.浙江省股东（或发起人）或投资人信息(自然人)信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsgdhtzrxxcx")
    public ResponseEntity<String> zjsgdhtzrxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsgdhtzrxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十八.浙江省法定代表人信息查询（二）
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsfddbrxxcx")
    public ResponseEntity<String> zjsfddbrxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsfddbrxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 三十九.浙江省公安厅机动车行驶证版式文件查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsgatjdcxczbswjcx")
    public ResponseEntity<String> zjsgatjdcxczbswjcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsgatjdcxczbswjcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("sfzhm", param.getIdCard());
        paramMap.add("syr", param.getUserName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十.浙江杭州规划局用地规划意见信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/guihuajujsxmydyj")
    public ResponseEntity<String> guihuajujsxmydyj(ProjectParamVO param) {
        // api签名
        String apiMethod = "guihuajujsxmydyj.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getProjectName());
        paramMap.add("id_nbr", param.getProjectNum());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十一.浙江杭州规划局建设工程设计方案审查意见书信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjhzghjjsgcsjfascyjsxxxcx")
    public ResponseEntity<String> zjhzghjjsgcsjfascyjsxxxcx(ProjectParamVO param) {
        // api签名
        String apiMethod = "zjhzghjjsgcsjfascyjsxxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getProjectName());
        paramMap.add("id_nbr", param.getProjectNum());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十二.浙江杭州国土建设用地批准书信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjhzgtjsydpzsxxxcx")
    public ResponseEntity<String> zjhzgtjsydpzsxxxcx(ProjectParamVO param) {
        // api签名
        String apiMethod = "zjhzgtjsydpzsxxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getProjectName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十三.浙江杭州国土建设项目用地预审信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjhzgtjsydysxxcx")
    public ResponseEntity<String> zjhzgtjsydysxxcx(ProjectParamVO param) {
        // api签名
        String apiMethod = "zjhzgtjsydysxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getProjectName());
        paramMap.add("id_nbr", param.getProjectNum());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十四.浙江省涉案民事刑事判决记录查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjssamsxspjjlcx")
    public ResponseEntity<String> zjssamsxspjjlcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjssamsxspjjlcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("name", param.getUserName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十五.浙江省机关事业养老保险参保人员信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjsjgsyylbqcbryxxcx")
    public ResponseEntity<String> zjsjgsyylbqcbryxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjsjgsyylbqcbryxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十六.浙江省事业单位人员基本信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/publicInstitutionInfo")
    public ResponseEntity<String> publicInstitutionInfo(BaseParamVO param) {
        // api签名
        String apiMethod = "publicInstitutionInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十七.浙江省宗教团体信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/ethnicReligion")
    public ResponseEntity<String> ethnicReligion(CompanyParamVO param) {
        // api签名
        String apiMethod = "ethnicReligion.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("orgName", param.getOrgName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十八.浙江省低保标准查询
     *
     * @param id
     * @param additional
     * @return
     */
    @PostMapping("/lowestStandardInfo")
    public ResponseEntity<String> lowestStandardInfo(String id, String additional) {
        // api签名
        String apiMethod = "lowestStandardInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id", id);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 四十九.浙江省勘察设计企业资质信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/surveyDesignInfo")
    public ResponseEntity<String> surveyDesignInfo(CompanyParamVO param) {
        // api签名
        String apiMethod = "surveyDesignInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("CorpCode", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十.浙江省建筑企业资质信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/constructionInfo")
    public ResponseEntity<String> constructionInfo(CompanyParamVO param) {
        // api签名
        String apiMethod = "constructionInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("uniscId", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十一.浙江省水利工程质量检测单位资质信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/waterInspectionInfo")
    public ResponseEntity<String> waterInspectionInfo(CompanyParamVO param) {
        // api签名
        String apiMethod = "waterInspectionInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("orgCode", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十二.浙江省水利工程建设监理企业资质信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/waterConstructionInfo")
    public ResponseEntity<String> waterConstructionInfo(CompanyParamVO param) {
        // api签名
        String apiMethod = "waterConstructionInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("uniscId", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十三.浙江省严重违法失信企业名单信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/VjV1fdce6emYEe8f")
    public ResponseEntity<String> VjV1fdce6emYEe8f(CompanyParamVO param) {
        // api签名
        String apiMethod = "VjV1fdce6emYEe8f.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("uniscid", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十四.浙江省行政处罚记录信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/administrativePenaltyRecordInfo")
    public ResponseEntity<String> administrativePenaltyRecordInfo(CompanyParamVO param) {
        // api签名
        String apiMethod = "administrativePenaltyRecordInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("companyName", param.getOrgName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十五.浙江省编办事业单位法人登记证查询
     *
     * @param param
     * @return
     */
    @PostMapping("/7ed5z6L4qSOq4F95")
    public ResponseEntity<String> method7ed5z6L4qSOq4F95(CompanyParamVO param) {
        // api签名
        String apiMethod = "7ed5z6L4qSOq4F95.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("sydwTycode", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十六.浙江杭州市建委初步设计批复信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/sjwcbsjpfxx")
    public ResponseEntity<String> sjwcbsjpfxx(ProjectParamVO param) {
        // api签名
        String apiMethod = "sjwcbsjpfxx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id_nbr", param.getProjectNum());
        paramMap.add("name", param.getProjectName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十七.浙江省建设项目环境影响评价文件的审批意见查询
     *
     * @param projectName
     * @param companyName
     * @param additional
     * @return
     */
    @PostMapping("/tG4YDd6Gx1JfMef0")
    public ResponseEntity<String> tG4YDd6Gx1JfMef0(String projectName, String companyName, String additional) {
        // api签名
        String apiMethod = "tG4YDd6Gx1JfMef0.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("JSDW", companyName);
        paramMap.add("XMMC", projectName);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十八.浙江杭州规划局建设工程规划核实信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/guihuajujsxmghhs")
    public ResponseEntity<String> guihuajujsxmghhs(ProjectParamVO param) {
        // api签名
        String apiMethod = "guihuajujsxmghhs.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id_nbr", param.getProjectNum());
        paramMap.add("name", param.getProjectName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 五十九.浙江杭州发改委通用信用核查
     *
     * @param param
     * @return
     */
    @PostMapping("/fgwUserService")
    public ResponseEntity<String> fgwUserService(FiftyNinthParamVO param) {
        // api签名
        String apiMethod = "fgwUserService.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("user", param.getUser());
        paramMap.add("xdrmc", param.getXdrmc());
        paramMap.add("type", param.getType());
        paramMap.add("password", param.getPassword());
        paramMap.add("xdrdm", param.getXdrdm());
        paramMap.add("code", param.getCode());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十.浙江省获取社会救助信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/dUzfwd0e86Z00oc4")
    public ResponseEntity<String> dUzfwd0e86Z00oc4(BaseParamVO param) {
        // api签名
        String apiMethod = "dUzfwd0e86Z00oc4.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("dsfz", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十一.浙江杭州国土局不动产权属证书信息查询
     *
     * @param bdcqzh
     * @param idCard
     * @param additional
     * @return
     */
    @PostMapping("/zjshzgtjbdcqczsxxcx")
    public ResponseEntity<String> zjshzgtjbdcqczsxxcx(String bdcqzh, String idCard, String additional) {
        // api签名
        String apiMethod = "zjshzgtjbdcqczsxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("lice_cd", bdcqzh);
        paramMap.add("id_nbr", idCard);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十二.浙江杭州国土抵押登记信息查询（新）
     *
     * @param param
     * @return
     */
    @PostMapping("/zjshzgtdydjxxcx")
    public ResponseEntity<String> zjshzgtdydjxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjshzgtdydjxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十三.浙江省失业保险参保人员信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/unemploymentInsuredInfo")
    public ResponseEntity<String> unemploymentInsuredInfo(BaseParamVO param) {
        // api签名
        String apiMethod = "unemploymentInsuredInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十四.浙江省城镇三无对象供养查询
     *
     * @param xzqh
     * @return
     */
    @PostMapping("/withoutSupportInfo")
    public ResponseEntity<String> withoutSupportInfo(String xzqh, String additional) {
        // api签名
        String apiMethod = "withoutSupportInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("czswdx_xzqh", xzqh);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十五.浙江省低保救助信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/lowestRescueInfo")
    public ResponseEntity<String> lowestRescueInfo(BaseParamVO param) {
        // api签名
        String apiMethod = "lowestRescueInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十六.浙江省企业基本信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/enterpriseInfo")
    public ResponseEntity<String> enterpriseInfo(SixtySixParamVO param) {
        // api签名
        String apiMethod = "enterpriseInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("uniscId", param.getUniscId());
        paramMap.add("companyName", param.getOrgName());
        paramMap.add("registerNo", param.getRegisterNo());
        paramMap.add("entType", param.getEntType());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十七. 浙江杭州教育局学籍信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/hqhzsxsxx")
    public ResponseEntity<String> hqhzsxsxx(BaseParamVO param) {
        // api签名
        String apiMethod = "hqhzsxsxx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十八.浙江杭州交警局非现场违法记录查询
     *
     * @param startTime
     * @param endTime
     * @param additional
     * @return
     */
    @PostMapping("/cgjfxcwfjlcx")
    public ResponseEntity<String> cgjfxcwfjlcx(String startTime, String endTime, String additional) {
        // api签名
        String apiMethod = "cgjfxcwfjlcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("startTime", startTime);
        paramMap.add("endTime", endTime);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 六十九.浙江杭州公积金缴纳信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/gongjijinpayinfo")
    public ResponseEntity<String> gongjijinpayinfo(BaseParamVO param) {
        // api签名
        String apiMethod = "gongjijinpayinfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十.浙江省建设厅建设规划许可证信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/CeN43cki4dk8x21a")
    public ResponseEntity<String> CeN43cki4dk8x21a(SeventiethParamVO param) {
        // api签名
        String apiMethod = "CeN43cki4dk8x21a.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("tyxydm", param.getTyxydm());
        paramMap.add("regno", param.getRegno());
        paramMap.add("idcard", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十一.浙江杭州房管公共租赁房租赁合同数据查询
     *
     * @param param
     * @return
     */
    @PostMapping("/fgjggzlfzlhtsjcx")
    public ResponseEntity<String> fgjggzlfzlhtsjcx(BaseParamVO param) {
        // api签名
        String apiMethod = "fgjggzlfzlhtsjcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("sfzh", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十二.浙江省建设厅建筑业企业资质证书信息查询
     *
     * @param certid
     * @param scucode
     * @param additional
     * @return
     */
    @PostMapping("/NHetdAdcd4bfCWXa")
    public ResponseEntity<String> NHetdAdcd4bfCWXa(String certid, String scucode, String additional) {
        // api签名
        String apiMethod = "NHetdAdcd4bfCWXa.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("certid", certid);
        paramMap.add("scucode", scucode);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十三.浙江省建设工程规划许可证内部共享
     *
     * @param buildJszh
     * @param additional
     * @return
     */
    @PostMapping("/07X8K1rTer190848")
    public ResponseEntity<String> method07X8K1rTer190848(String buildJszh, String additional) {
        // api签名
        String apiMethod = "07X8K1rTer190848.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("buildJszh", buildJszh);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十四.浙江省边缘救助对象基本信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/edgeRescuePerBasicInfo")
    public ResponseEntity<String> edgeRescuePerBasicInfo(BaseParamVO param) {
        // api签名
        String apiMethod = "edgeRescuePerBasicInfo.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十五.浙江省低保标准查询（新）
     *
     * @param id
     * @param additional
     * @return
     */
    @PostMapping("/lowestStandardInfocx")
    public ResponseEntity<String> lowestStandardInfocx(String id, String additional) {
        // api签名
        String apiMethod = "lowestStandardInfocx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id", id);
        paramMap.add("additional", additional);
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十六.浙江省事业单位人员基本信息查询（新）
     *
     * @param param
     * @return
     */
    @PostMapping("/publicInstitutionInfocx")
    public ResponseEntity<String> publicInstitutionInfocx(BaseParamVO param) {
        // api签名
        String apiMethod = "publicInstitutionInfocx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十七.浙江杭州民政伤残军人信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/minzhengdsblsoldier")
    public ResponseEntity<String> minzhengdsblsoldier(BaseParamVO param) {
        // api签名
        String apiMethod = "minzhengdsblsoldier.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十八.浙江杭州民政局特困人员信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/mzjtkryxx")
    public ResponseEntity<String> mzjtkryxx(BaseParamVO param) {
        // api签名
        String apiMethod = "mzjtkryxx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("SFZH", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 七十九.浙江杭州民政局社会救助档案信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/79")
    public ResponseEntity<String> method79(BaseParamVO param) {
        // TODO: 2020/9/2 [matianhao] 缺少请求地址
        // api签名
        String apiMethod = "method.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("name", param.getUserName());
        paramMap.add("cardId", param.getIdCard());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 八十一.浙江省建设厅建筑施工企业安全生产许可证信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/Z3X4061Lz4dZ4sc9")
    public ResponseEntity<String> Z3X4061Lz4dZ4sc9(CompanyParamVO param) {
        // api签名
        String apiMethod = "Z3X4061Lz4dZ4sc9.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("dwmc", param.getOrgName());
        paramMap.add("tyshxydm", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 八十五.浙江杭州国土局查封登记基础信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjshzgtjcfdjjcxxcx")
    public ResponseEntity<String> zjshzgtjcfdjjcxxcx(BaseParamVO param) {
        // api签名
        String apiMethod = "zjshzgtjcfdjjcxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("id_nbr", param.getIdCard());
        paramMap.add("name", param.getUserName());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    /**
     * 八十六.浙江省杭州市企业股东信息查询
     *
     * @param param
     * @return
     */
    @PostMapping("/zjhzqygdxxcx")
    public ResponseEntity<String> zjhzqygdxxcx(CompanyParamVO param) {
        // api签名
        String apiMethod = "zjhzqygdxxcx.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("qymc", param.getOrgName());
        paramMap.add("uniscid", param.getUniscId());
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

    @PostMapping("/")
    public ResponseEntity<String> method(BaseParamVO param) {
        // api签名
        String apiMethod = "method.action";
        // api参数
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<>();
        paramMap.add("additional", param.getAdditional());
        return restTemplateService.commonSendRequest(paramMap, apiMethod);
    }

}
