package com.mth.requestsecret.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.mth.requestsecret.constant.Constants;
import com.mth.requestsecret.util.DSLUtils;
import com.mth.requestsecret.util.MD5Utils;
import com.mth.requestsecret.util.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author MaTianHao
 * @date 2020/7/10
 */
@Component
@Configuration
@EnableScheduling
public class RequestSecretSchedulerTask implements SchedulingConfigurer {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    RedisUtils redisUtil;

    @Value("${ruicheng.address}")
    private String pathUrl;

    @Value("${ruicheng.key}")
    private String appKey;

    @Value("${ruicheng.secret}")
    private String appSecret;

    /**
     * 请求秘钥
     */
    public static String requestSecret = null;
    /**
     * 请求秘钥过期时间
     */
    private static Long requestSecretEndTime = null;
    /**
     * 刷新秘钥
     */
    public static String refreshSecret = null;
    /**
     * 刷新秘钥过期时间
     */
    private static Long refreshSecretEndTime = null;

    @Override
    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(
                () -> System.out.println("定时任务获取requestSecret：" + LocalDateTime.now().toString()),
                triggerContext -> {
                    getRequestSecret();
                    // 提前一分钟刷新
                    Instant instant = Instant.ofEpochMilli(requestSecretEndTime).minus(1, ChronoUnit.MINUTES);
                    return Date.from(instant);
                }
        );
    }

    /**
     * 获取请求秘钥
     */
    public void getRequestSecret() {
        String url = pathUrl + "/interface/public/service/risen-inte/reTokenByKey.action" +
                "?appKey={appKey}&sign={sign}&requestTime={requestTime}";

        // 请求时间
        String requestTime = DSLUtils.dateToLong(new Date()) + "";
        // 签名字符串
        String signStr = appKey + appSecret + requestTime;

        // 组装请求参数
        Map<String, Object> map = new HashMap<String, Object>(3) {{
            put("appKey", appKey);
            put("sign", MD5Utils.encoderByMd5(signStr));
            put("requestTime", requestTime);
        }};
        // 获取请求秘钥和刷新秘钥
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(url, String.class, map);

        // 解析返回结果
        JSONObject datas = JSONObject.parseObject(responseEntity.getBody()).getJSONObject("datas");
        if (!Objects.isNull(datas)) {
            requestSecret = datas.getString("requestSecret");
            requestSecretEndTime = Long.parseLong(datas.getString("requestSecretEndTime"));
            refreshSecret = datas.getString("refreshSecret");
            refreshSecretEndTime = Long.parseLong(datas.getString("refreshSecretEndTime"));
            // 保存请求秘钥至redis
            redisUtil.set(Constants.SJJ_REQUEST_SECRET_PREFIX, requestSecret);
        }
    }

}
